#include <iostream>
#include <cstring>
#include <cstdio>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
using namespace std;

typedef pair<int, int> ii;
typedef vector<int> vi;
typedef vector<vi> vvi;
typedef vector<ii> vii;

template <class T> int size(const T &x) { return x.size(); }

vii *adj;
int n, m;
vector<bool> used;
int mem[110];
int forward[110];

int dp(int at) {
    if (mem[at] != -1)
    {
        return mem[at];
    }

    forward[at] = -1;

    int cur = 0;
    for (int i = 0; i < size(adj[at]); i++) {
        int nxt = adj[at][i].first;
        int e = adj[at][i].second;
        int now = 0;
        if (!used[e]) {
            now++;
        }
        now += dp(nxt);
        if (now > cur) {
            forward[at] = e;
            cur = now;
        }
    }

    return mem[at] = cur;
}

int main() {

    scanf("%d\n", &n);

    adj = new vii[n];

    vector<ii> edge;

    for (int i = 0; i < n; i++) {
        int cnt;
        scanf("%d", &cnt);
        for (int j = 0; j < cnt; j++) {
            int x;
            scanf("%d", &x);
            x--;
            adj[i].push_back(ii(x, size(edge)));
            edge.push_back(ii(i, x));
        }
    }

    m = size(edge);
    used = vector<bool>(m, false);

    vvi paths;

    while (true) {
        int mx = 0,
            mxi = -1;

        memset(mem, -1, sizeof(mem));

        for (int i = 0; i < n; i++) {
            int cur = dp(i);
            if (cur > mx) {
                mx = cur;
                mxi = i;
            }
        }

        if (mx == 0) {
            break;
        }

        vi path;
        int at = mxi;
        while (true) {
            path.push_back(at);
            int e = forward[at];
            if (e == -1)
                break;

            used[e] = true;
            at = edge[e].second;
        }

        paths.push_back(path);
    }

    printf("%d\n", size(paths));
    for (int i = 0; i < size(paths); i++) {
        for (int j = 0; j < size(paths[i]); j++) {
            if (j != 0) printf(" ");
            printf("%d", paths[i][j] + 1);
        }

        printf("\n");
    }

    return 0;
}
